/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.ast;

import icyllis.annotations.NotNull;
import icyllis.flexmark.ast.DelimitedLinkNode;
import icyllis.flexmark.util.sequence.BasedSequence;

public class AutoLink
extends DelimitedLinkNode {
    public AutoLink() {
    }

    @Override
    @NotNull
    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.pageRef, this.anchorMarker, this.anchorRef, this.closingMarker};
    }

    @Override
    @NotNull
    public BasedSequence[] getSegmentsForChars() {
        return new BasedSequence[]{this.openingMarker, this.pageRef, this.anchorMarker, this.anchorRef, this.closingMarker};
    }

    @Override
    public void getAstExtra(@NotNull StringBuilder out) {
        AutoLink.segmentSpanChars(out, this.openingMarker, "open");
        AutoLink.segmentSpanChars(out, this.text, "text");
        if (this.pageRef.isNotNull()) {
            AutoLink.segmentSpanChars(out, this.pageRef, "pageRef");
        }
        if (this.anchorMarker.isNotNull()) {
            AutoLink.segmentSpanChars(out, this.anchorMarker, "anchorMarker");
        }
        if (this.anchorRef.isNotNull()) {
            AutoLink.segmentSpanChars(out, this.anchorRef, "anchorRef");
        }
        AutoLink.segmentSpanChars(out, this.closingMarker, "close");
    }

    public AutoLink(BasedSequence chars) {
        super(chars);
    }

    public AutoLink(BasedSequence openingMarker, BasedSequence text, BasedSequence closingMarker) {
        super(openingMarker, text, closingMarker);
        this.setUrlChars(text);
    }
}

